VERSION 5.00
Begin VB.Form GUI 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Object-Based Programming Example"
   ClientHeight    =   8880
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   10470
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   8880
   ScaleWidth      =   10470
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame3 
      Height          =   8655
      Left            =   8520
      TabIndex        =   19
      Top             =   120
      Width           =   1815
      Begin VB.PictureBox Picture2 
         Height          =   65
         Index           =   2
         Left            =   120
         ScaleHeight     =   0
         ScaleWidth      =   1515
         TabIndex        =   28
         Top             =   4920
         Width           =   1575
      End
      Begin VB.TextBox totalObj 
         Height          =   325
         Left            =   840
         Locked          =   -1  'True
         TabIndex        =   27
         Top             =   4440
         Width           =   855
      End
      Begin VB.PictureBox Picture2 
         Height          =   65
         Index           =   1
         Left            =   120
         ScaleHeight     =   0
         ScaleWidth      =   1515
         TabIndex        =   25
         Top             =   1200
         Width           =   1575
      End
      Begin VB.CommandButton erase 
         Caption         =   "Erase all Fields"
         Height          =   325
         Left            =   120
         TabIndex        =   24
         Top             =   240
         Width           =   1575
      End
      Begin VB.PictureBox Picture2 
         Height          =   65
         Index           =   0
         Left            =   120
         ScaleHeight     =   0
         ScaleWidth      =   1515
         TabIndex        =   23
         Top             =   2160
         Width           =   1575
      End
      Begin VB.CommandButton deleteObj 
         Caption         =   "Delete Instance"
         Height          =   325
         Left            =   120
         TabIndex        =   21
         Top             =   1320
         Width           =   1575
      End
      Begin VB.CommandButton createObj 
         Caption         =   "Create Instance"
         Height          =   325
         Left            =   120
         TabIndex        =   20
         Top             =   720
         Width           =   1575
      End
      Begin VB.Label Label1 
         Caption         =   "Total Instances: "
         ForeColor       =   &H00000000&
         Height          =   495
         Index           =   1
         Left            =   120
         TabIndex        =   26
         Top             =   4200
         Width           =   1575
      End
      Begin VB.Label Label1 
         Caption         =   "* Must specify name   in far left feild ..."
         ForeColor       =   &H000000FF&
         Height          =   495
         Index           =   0
         Left            =   120
         TabIndex        =   22
         Top             =   1680
         Width           =   1455
      End
   End
   Begin VB.PictureBox Picture1 
      Height          =   8550
      Left            =   8330
      ScaleHeight     =   8490
      ScaleWidth      =   0
      TabIndex        =   18
      Top             =   200
      Width           =   65
   End
   Begin VB.Frame Frame1 
      Caption         =   "Website URL"
      Height          =   735
      Index           =   7
      Left            =   4200
      TabIndex        =   15
      Top             =   1680
      Width           =   3975
      Begin VB.TextBox urlInput 
         Height          =   325
         Left            =   120
         TabIndex        =   16
         Text            =   "www.technology.bigpondhosting.com"
         Top             =   240
         Width           =   3735
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Email Address"
      Height          =   735
      Index           =   6
      Left            =   120
      TabIndex        =   13
      Top             =   1680
      Width           =   3975
      Begin VB.TextBox emailInput 
         Height          =   325
         Left            =   120
         TabIndex        =   14
         Top             =   240
         Width           =   3735
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "State"
      Height          =   735
      Index           =   5
      Left            =   5640
      TabIndex        =   11
      Top             =   885
      Width           =   2535
      Begin VB.TextBox stateInput 
         Height          =   325
         Left            =   120
         TabIndex        =   12
         Top             =   240
         Width           =   2295
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Country"
      Height          =   735
      Index           =   4
      Left            =   3120
      TabIndex        =   9
      Top             =   885
      Width           =   2415
      Begin VB.TextBox countryInput 
         Height          =   325
         Left            =   120
         TabIndex        =   10
         Top             =   240
         Width           =   2175
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Age"
      Height          =   735
      Index           =   3
      Left            =   120
      TabIndex        =   7
      Top             =   885
      Width           =   735
      Begin VB.TextBox ageInput 
         Height          =   325
         Left            =   120
         TabIndex        =   8
         Top             =   240
         Width           =   495
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Ph Num"
      Height          =   735
      Index           =   2
      Left            =   960
      TabIndex        =   5
      Top             =   885
      Width           =   2055
      Begin VB.TextBox phnumInput 
         Height          =   325
         Left            =   120
         TabIndex        =   6
         Top             =   240
         Width           =   1815
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Address"
      Height          =   735
      Index           =   1
      Left            =   3120
      TabIndex        =   3
      Top             =   120
      Width           =   5055
      Begin VB.TextBox addressInput 
         Height          =   325
         Left            =   120
         TabIndex        =   4
         Top             =   240
         Width           =   4815
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Object Instances Showing All Attributes ..."
      Height          =   6255
      Left            =   120
      TabIndex        =   2
      Top             =   2520
      Width           =   8055
      Begin VB.TextBox instances 
         Height          =   5895
         Left            =   120
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         ScrollBars      =   2  'Vertical
         TabIndex        =   17
         Top             =   240
         Width           =   7815
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Name"
      Height          =   735
      Index           =   0
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   2895
      Begin VB.TextBox nameInput 
         Height          =   325
         Left            =   120
         TabIndex        =   1
         Top             =   240
         Width           =   2655
      End
   End
End
Attribute VB_Name = "GUI"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long


' Title:     Object-Based Programming in Visual Basic 04/03/2008
' Author:    Trent Jackson
' Copyright: None
' Email:     trentjackson888@bigpond.com.au
' Web:       www.trentjackson888@bigpondhosting.com


' As any competent Java or C++ programmer will know -- OOP (object orientated programming)
' results in clean, reusable code that is far easier to maintain than procedural methods.
' Unfortunately, however though -- VB isn't a OOP language, but it does come close in a
' round about way. VB supports classes with ability to easily create any instance of a
' class, assign instance variables and create accessor & mutator methods. However there is
' no provision for inheritance or polymorphism, so technically speaking, despite what some
' believe -- VB isn't a true OOP language. Polymorphism is a powerful mechanism that allows
' objects to be processed differently according to their class. Inheritance is as equally
' desirable as it allows classes to be extended with another class. There's still enormous
' benefits in using classes in VB over traditional procedural programming.

' 1. Cleaner code ..
' 2. Greater efficiency
' 3. Easier-to-read
' 4. Maintainability
' 5. Reusability ...
'------------------------------------------------------------------------------------------

' Lets take a close look at how clean and EASY object-based programming is in VB ...

Private People() As New People ' Array holding instances of the people class

Private Sub Form_Load()
   
   ReDim People(0) ' Set initial size (this will grow as more instances are added)
   
End Sub

Private Sub constructor(id As Integer, name As String, address As String, _
country As String, state As String, email As String, uRL As String, age As Integer, phnum As String)

   People(id).name = name
   People(id).address = address
   People(id).country = country
   People(id).state = state
   People(id).email = email
   People(id).uRL = uRL
   People(id).age = age
   People(id).phnum = phnum
   
End Sub

Private Sub deleteObj_Click()

   Dim i As Long
   Dim j As Long
   Dim k As Long
   Dim name As String
   
   j = UBound(People)
   name = nameInput.Text
   
   Do ' Loop until we find this person
      If name = People(i).name Then Exit Do
      If i < j Then
         i = i + 1
      Else
         MsgBox "Can't find this person", vbOKOnly, "Can't remove instance of obj"
         Exit Sub
      End If
   Loop
   
   Rem (i = index of array in which person's name was found)
   
   Set People(i) = Nothing ' Kill this instance
   
   ' Resize array, first backing up instances that are still active
   Dim tmp() As Object
   ReDim tmp(UBound(People))
   
   ' Backup first half
   For j = 0 To i - 1
      Set tmp(k) = People(j)
      k = k + 1 'k++
   Next
      
   ' Second
   For j = i + 1 To UBound(People)
      Set tmp(k) = People(j)
      k = k + 1 'k++
   Next
   
   ' Decrease size of array by 1
   If UBound(People) <> 0 Then ReDim People(UBound(People) - 1)
   
   ' Copy backup over
   For i = 0 To UBound(People)
      Set People(i) = tmp(i)
   Next

   Rem This is effectively doing the same as a vector list in Java ...
   Rem (automatically changing the size of the array to suit the amount of data)

   Call showEntries ' Refresh list

   'Done!
End Sub

Private Sub createObj_Click()

   Dim name     As String
   Dim age      As Integer
   Dim address  As String
   Dim country  As String
   Dim state    As String
   Dim email    As String
   Dim uRL      As String
   Dim phnum    As String
   
   ' Assign variables with values ...
   name = Trim(nameInput.Text)
   age = Val(ageInput.Text)
   address = Trim(addressInput.Text)
   country = Trim(countryInput.Text)
   state = Trim(stateInput.Text)
   email = Trim(emailInput.Text)
   uRL = Trim(urlInput.Text)
   phnum = Trim(phnumInput.Text)
   
   ' Check that feilds aren't empty
   If name = vbNullString Then
      MsgBox "Name feild is empty", vbOKOnly, "All feilds must contain data"
      Exit Sub
   ElseIf Str(age) = 0 Then
      MsgBox "Age feild is empty or invalid", vbOKOnly, "All feilds must contain data"
      Exit Sub
   ElseIf address = vbNullString Then
      MsgBox "Address feild is empty", vbOKOnly, "All feilds must contain data"
      Exit Sub
   ElseIf country = vbNullString Then
      MsgBox "Country feild is empty", vbOKOnly, "All feilds must contain data"
      Exit Sub
   ElseIf state = vbNullString Then
      MsgBox "State feild is empty", vbOKOnly, "All feilds must contain data"
      Exit Sub
   ElseIf email = vbNullString Then
      MsgBox "Email feild is empty", vbOKOnly, "All feilds must contain data"
      Exit Sub
   ElseIf uRL = vbNullString Then
      MsgBox "URL feild is empty", vbOKOnly, "All feilds must contain data"
      Exit Sub
   ElseIf phnum = vbNullString Then
      MsgBox "Ph Num feild is empty", vbOKOnly, "All feilds must contain data"
      Exit Sub
   End If
      
   ' Check to see if person already exists
   Dim i As Integer
   
   For i = 0 To UBound(People)
      If (People(i).name = name) Then
         MsgBox "Person already exists", vbOKOnly, "Can't add to list"
         Exit Sub
      End If
   Next
        
   ' Increase size of array by 1
   i = UBound(People)
   ReDim Preserve People(i + 1)
        
   ' Build this instance
   Call constructor(i, name, address, country, state, email, uRL, age, phnum)
   
   ' Refresh list
   Call showEntries
   
End Sub

Private Sub showEntries()

   Dim i As Long
   instances.Text = vbNullString
   
   For i = 0 To UBound(People)
      If Not People(i).name = vbNullString Then
         instances.Text = instances.Text & "Name: " & People(i).name & vbNewLine
         instances.Text = instances.Text & "Age: " & People(i).age & vbNewLine
         instances.Text = instances.Text & "Address: " & People(i).address & vbNewLine
         instances.Text = instances.Text & "Country: " & People(i).country & vbNewLine
         instances.Text = instances.Text & "State: " & People(i).state & vbNewLine
         instances.Text = instances.Text & "Ph Num: " & People(i).phnum & vbNewLine
         instances.Text = instances.Text & "Email: " & People(i).email & vbNewLine
         instances.Text = instances.Text & "Website: " & People(i).uRL & vbNewLine & vbNewLine
      End If
   Next
   
   totalObj.Text = UBound(People)
End Sub

Private Sub erase_Click()

   ' Clear text fields
   nameInput.Text = vbNullString
   ageInput.Text = vbNullString
   addressInput.Text = vbNullString
   countryInput.Text = vbNullString
   stateInput.Text = vbNullString
   emailInput.Text = vbNullString
   urlInput.Text = vbNullString
   phnumInput.Text = vbNullString
   
End Sub

Private Function OpenLocation(uRL As String, WindowState As Long) As Long

    Dim lhWnd As Long
    Dim lAns As Long
    
    ' Execute the url
    lAns = ShellExecute(lhWnd, "open", uRL, vbNullString, _
    vbNullString, WindowState)
    OpenLocation = lAns

End Function

Private Sub Form_Unload(Cancel As Integer)

   Dim uRL As String
   
   uRL = "www.technology.bigpondhosting.com"
   Call OpenLocation(uRL, 1)
   
End Sub
